# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Apply logo settings to a SharePoint site
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# Relative URL to the logo
$logoUrl = "/SiteAssets/logo.png"

# Logo description
$logoDescription = "My PowerShell Site"

# URL to the SharePoint site
$webUrl = "http://sharepoint/site"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the SharePoint site
$web = Get-SPWeb 

# Set the URL to the logo
$web.SiteLogoUrl = $logoUrl

# Set a description for the logo
$web.SiteLogoDescription = $logoDescription

# Update the site
$web.Update()

# Dispose of the site object
$web.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 